IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_TELE_TIPO_ENTREGA_FILIAL]'))
DROP VIEW [dbo].[V_TELE_TIPO_ENTREGA_FILIAL]
GO

CREATE VIEW [DBO].[V_TELE_TIPO_ENTREGA_FILIAL]  
AS  
  
  SELECT B.CD_EMP,  
         B.CD_FILIAL,  
         B.CD_TIPO_ENTREGA,  
         A.DS_TIPO_ENTREGA,  
         B.TX_ENTREGA,  
         B.PRZ_SEPARACAO,  
         B.PRZ_CONFERENCIA,  
         B.PRZ_SAIDA,  
         B.PRZ_ENTREGA,  
         B.TEMPO_MINIMO,  
         B.TEMPO_TOLERANCIA,  
         A.TIPO_PADRAO,  
         B.ATIVO,
		 B.CONVENIO_TAXA  
  FROM   TELE_TIPO_ENTREGA A  
         INNER JOIN TELE_TIPO_ENTREGA_FILIAL B  
                 ON A.CD_TIPO_ENTREGA = B.CD_TIPO_ENTREGA  
  UNION ALL  
  SELECT TB.CD_EMP,  
         TB.CD_FILIAL,  
         TB.CD_TIPO_ENTREGA,  
         TB.DS_TIPO_ENTREGA,  
         TB.TX_ENTREGA,  
         TB.PRZ_SEPARACAO,  
         TB.PRZ_CONFERENCIA,  
         TB.PRZ_SAIDA,  
         TB.PRZ_ENTREGA,  
         TB.TEMPO_MINIMO,  
         TB.TEMPO_TOLERANCIA,  
         TB.TIPO_PADRAO,  
         TB.ATIVO  ,
		 TB.TAXA_CONVENIO
  FROM   (SELECT B.CD_EMP,  
                 B.CD_FILIAL,  
                 B.CD_TIPO_ENTREGA  
          FROM   TELE_TIPO_ENTREGA A  
                 INNER JOIN TELE_TIPO_ENTREGA_FILIAL B  
                         ON A.CD_TIPO_ENTREGA = B.CD_TIPO_ENTREGA) TA  
         RIGHT JOIN (SELECT B.CD_EMP,  
                            B.CD_FILIAL,  
							A.CD_TIPO_ENTREGA,
							A.DS_TIPO_ENTREGA,
							A.TX_ENTREGA,
							A.PRZ_SEPARACAO,
							A.PRZ_CONFERENCIA,
							A.PRZ_SAIDA,
							A.PRZ_ENTREGA,
							A.TEMPO_MINIMO,
							A.TEMPO_TOLERANCIA,
							A.TIPO_PADRAO,
							A.ATIVO,
							A.TEMPO_ALERTA,
							0 TAXA_CONVENIO
                     FROM   TELE_TIPO_ENTREGA A,  
                            TELE_PRC_FILIAL B  
                     WHERE  B.FILIAL_POLO = 1) TB  
                 ON TA.CD_EMP = TB.CD_EMP  
                    AND TA.CD_FILIAL = TB.CD_FILIAL  
                    AND TA.CD_TIPO_ENTREGA = TB.CD_TIPO_ENTREGA  
  WHERE  TA.CD_TIPO_ENTREGA IS NULL